/*
 * This file is part of Renewed City Growth, a GameScript for OpenTTD.
 * Copyright (C) 2013-2014 keoz
 *
 * It's free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the
 * Free Software Foundation, version 2 of the License.
 *
 */


/* Function which builds town texts.
 * Town text will look like below:
 * Cargocat label: required/last supplied/stockpiled
 */
function GoalTown::TownBoxText(growth_enabled)
{
	// If the function is called with false, town is not growing. Give a help message.
	if (!growth_enabled) return GSText(GSText.STR_TOWNBOX_NOGROWTH);
	
	// Building an array of substrings. Labels depend on categories number.
	local text_townbox_cargocat = [];
	switch (::CargoCatNum) {
		case(3):
			text_townbox_cargocat.append(GSText(GSText.STR_TOWNBOX_PAXMAIL));
			text_townbox_cargocat.append(GSText(GSText.STR_TOWNBOX_GGOODS));
			text_townbox_cargocat.append(GSText(GSText.STR_TOWNBOX_GIND));
			break;
		case(5):
			text_townbox_cargocat.append(GSText(GSText.STR_TOWNBOX_PAXMAIL));
			text_townbox_cargocat.append(GSText(GSText.STR_TOWNBOX_GFOOD));
			text_townbox_cargocat.append(GSText(GSText.STR_TOWNBOX_GGOODS));
			text_townbox_cargocat.append(GSText(GSText.STR_TOWNBOX_RAWIND));
			text_townbox_cargocat.append(GSText(GSText.STR_TOWNBOX_TRANIND));
			break;
	}

	// Adding numeric parameters and building the final string
	local text_townbox = GSText(GSText.STR_TOWNBOX);
	for (local i = 0; i < ::CargoCatNum; i++) {
		text_townbox_cargocat[i].AddParam(this.town_goals_cat[i]);
		text_townbox_cargocat[i].AddParam(this.town_supplied_cat[i]);
		text_townbox_cargocat[i].AddParam(this.town_stockpiled_cat[i]);
		text_townbox.AddParam(text_townbox_cargocat[i]);
	}

	return text_townbox;
}

/* Building the text for towns' signtexts. */
function GoalTown::TownSignText()
{
	local text_townsign = GSText(GSText.STR_TOWNSIGN_GROWTHRATE, GSTown.GetGrowthRate(this.id));
	return text_townsign;
}

/* Helper function: get a list of currently used cargo labels/ID. */
function DebugCargoLabels()
{
	local list = GSCargoList();
	for(local i = 0; i < 32; ++i) {
		Log.Info(i + " = " + GSCargo.GetCargoLabel(i), Log.LVL_DEBUG);
	}
}

/* Debug function: print supplied cargo. */
function GoalTown::DebugCargoSupplied(i)
{
	Log.Info(GSTown.GetName(this.id)+": supplied "+GSCargo.GetCargoLabel(CargoList[i])+"="
		 +town_supplied[i], Log.LVL_DEBUG);
}

/* Debug function: print stockpiled/supplied/goal per cargo category. */
function GoalTown::DebugCargoCatInfo(i)
{
	Log.Info(GSTown.GetName(this.id)+": Cat. "+(i+1)
		 +" - Goal="+this.town_goals_cat[i]
		 +" Supplied="+this.town_supplied_cat[i]
		 +" Stockpiled="+this.town_stockpiled_cat[i], Log.LVL_DEBUG);
}

/* Debug function: print the general goals achievement before calculating the new TGR. */
function GoalTown::DebugGoalsResult(sumgoals, goaldiff, goaldiffpercent)
{
	Log.Info(GSTown.GetName(this.id)+": sumgoals="+sumgoals+" goaldiff="+goaldiff+" goaldiffpercent="
		 +goaldiffpercent, Log.LVL_DEBUG);
}

/* Debug function: print the content of the TGR array. */
function GoalTown::DebugTgrArray()
{
	local array_text = " ";
	foreach (i, val in this.tgr_array) {
		array_text = array_text+"i"+i+"="+val+" ";
	}
	Log.Info(GSTown.GetName(this.id)+": "+array_text+"Average="+this.tgr_average, Log.LVL_DEBUG);
}
