/*
 * This file is part of Renewed City Growth, a GameScript for OpenTTD.
 * Copyright (C) 2013-2014 keoz
 *
 * It's free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the
 * Free Software Foundation, version 2 of the License.
 *
 */


/* Here are defined the cargo categories and other data for each set
 * and some other data. For cargo Id references, see cargo_labels.txt.
 */
function DefineCargosBySettings()
{
	/* Setup Global Cargo Variables, per cargo categories: (Cat 1:
	 * Passengers and mail, Cat 2: General food, Cat 3: General
	 * goods, Cat 4: Raw industrial materials, Cat 5: transformed
	 * indudstrial goods). For base sets, only 3 categories are
	 * defined (PaxMail, General goods (including food),
	 * industrial goods).
	 * For each industry set, we define:
	 * ::CargolistCat: the base categories of cargo
	 * ::CargoMinPopDemand: minimal town population at which a
	 * cargo category is required
	 * ::CargoPermille: a factor defining the growth of cargo category
	 * requirements
	 * ::CargoDecay: defines the part of the stockpiled cargos
	 * which is lost each month
	 */
	local industry_setting = GSController.GetSetting("industry_NewGRF");
	switch (industry_setting) {
		case(1): // Base temperate
			::CargoListCat <- [[0,2],
					   [5,10],
					   [1,3,4,6,7,8,9]]
			::CargoMinPopDemand <- [0,1000,4000];
			::CargoPermille <- [60,45,25];
			::CargoDecay <- [0.4,0.2,0.1];
			::CargoCatStrings <- ["PaxMail","GGoods","GInd"];
			break;
		case(2): //Base arctic
			::CargoListCat <- [[0,2],
					   [5,10,11],
					   [1,3,4,6,7,9]]
			::CargoMinPopDemand <- [0,1000,4000];
			::CargoPermille <- [60,45,25];
			::CargoDecay <- [0.4,0.2,0.1];
			::CargoCatStrings <- ["PaxMail","GGoods","GInd"];
			break;
		case(3): //Base tropical
			::CargoListCat <- [[0,2],
					   [5,9,10,11],
					   [1,3,4,6,7,8]]
			::CargoMinPopDemand <- [0,1000,4000];
			::CargoPermille <- [60,45,25];
			::CargoDecay <- [0.4,0.2,0.1];
			::CargoCatStrings <- ["PaxMail","GGoods","GInd"];
			break;
		case(4): //Base toyland
			::CargoListCat <- [[0,2],
					   [3,5,11],
					   [1,4,6,7,8,9,10]]
			::CargoMinPopDemand <- [0,1000,4000];
			::CargoPermille <- [60,45,25];
			::CargoDecay <- [0.4,0.2,0.1];
			::CargoCatStrings <- ["PaxMail","GGoods","GInd",];
			break;
		case(5): // FIRS - Firs Economy
			::CargoListCat <- [[0,2],
					   [11,13,29],
					   [5,25,28],
					   [1,3,4,6,7,8,10,12,14,15,16,17,20,22,26,27],
					   [9,18,19,21,23,24,31]]
			::CargoMinPopDemand <- [0,500,1000,4000,8000];
			::CargoPermille <- [60,25,20,15,10];
			::CargoDecay <- [0.4,0.2,0.2,0.1,0.1];
			::CargoCatStrings <- ["PaxMail","GFood","GGoods","RawInd","TransInd"];
			break;
		case(6): // FIRS - Temperate Basic
			::CargoListCat <- [[0,2],
					   [11,29],
					   [5],
					   [1,4,8,10,13,16,17,20],
					   [9,18,21,23,24]]
			::CargoMinPopDemand <- [0,500,1000,4000,8000];
			::CargoPermille <- [60,25,20,15,10];
			::CargoDecay <- [0.4,0.2,0.2,0.1,0.1];
			::CargoCatStrings <- ["PaxMail","GFood","GGoods","RawInd","TransInd"];
			break;
		case(7): // FIRS - Arctic Basic
			::CargoListCat <- [[0,2],
					   [11,29],
					   [5,25],
					   [3,4,6,7,14],
					   [16,18,21,23,24]]
			::CargoMinPopDemand <- [0,500,1000,4000,8000];
			::CargoPermille <- [60,25,20,15,10];
			::CargoDecay <- [0.4,0.2,0.2,0.1,0.1];
			::CargoCatStrings <- ["PaxMail","GFood","GGoods","RawInd","TransInd"];
			break;
		case(8): // FIRS - Tropic Basic
			::CargoListCat <- [[0,2],
					   [11],
					   [5,25],
					   [3,4,12,13,14,15,27],
					   [9,18,21,23,24]]
			::CargoMinPopDemand <- [0,500,1000,4000,8000];
			::CargoPermille <- [60,25,20,15,10];
			::CargoDecay <- [0.4,0.2,0.2,0.1,0.1];
			::CargoCatStrings <- ["PaxMail","GFood","GGoods","RawInd","TransInd"];
			break;
		case(9): // FIRS - Hearth of the Darkness
			::CargoListCat <- [[0,2],
					   [11,29],
					   [5,28],
					   [1,3,7,8,12,13,14,15,22,27],
					   [6,18,20,21,24]]
			::CargoMinPopDemand <- [0,500,1000,4000,8000];
			::CargoPermille <- [60,25,20,15,10];
			::CargoDecay <- [0.4,0.2,0.2,0.1,0.1];
			::CargoCatStrings <- ["PaxMail","GFood","GGoods","RawInd","TransInd"];
			break;
		case(10): //ECS
			::CargoListCat <- [[0,2,31],
					   [11,27],
					   [5,10,25,28],
					   [1,3,4,6,7,8,9,13,14,15,17,22,26,29],
					   [12,18,19,20,21,23,24]]
			::CargoMinPopDemand <- [0,500,1000,4000,8000];
			::CargoPermille <- [60,25,20,15,10];
			::CargoDecay <- [0.4,0.2,0.2,0.1,0.1];
			::CargoCatStrings <- ["PaxMail","GFood","GGoods","RawInd","TransInd"];
			break;
		default:
			break;
	}
}

function InitCargoLists()
{
	DebugCargoLabels();  // Debug info: print cargo labels

	DefineCargosBySettings();

	// Building a general list of all cargos, ordered by categories.
	::CargoList <- [];
	for (local i = 0; i < ::CargoListCat.len(); i++) {
		for (local j = 0; j < ::CargoListCat[i].len(); j++) {
			::CargoList.append(CargoListCat[i][j]);
		}
	}

	// Initializing some useful and often used variables
	::CargoTypeNum <- ::CargoList.len();
	::CargoCatNum <- ::CargoListCat.len();
}
