/*
 * This file is part of Renewed City Growth and Tile Label Industry Builder, a GameScripts for OpenTTD
 * Copyright (C) 2013-2014 keoz, McZapkie
 *
 * It's free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the
 * Free Software Foundation, version 2 of the License.
 *
 */


require("version.nut");

class MainClass extends GSInfo 
	{
	function GetAuthor()		{ return "keoz,McZapkie"; }
	function GetName()		{ return "Renewed City Growth + Tile Label Industry Builder"; }
	function GetDescription() 	{ return "1. A city growth script. Towns require various cargo delivery to grow. Supporting Baseset, FIRS and ECS industries. 2.Tile labels allow to build industry during game play"; }
	function GetVersion()		{ return SELF_VERSION; }
	function GetDate()		{ return "2014-09-23"; }
	function CreateInstance()	{ return "MainClass"; }
	function GetShortName()	{ return "RCGT"; }
	function GetAPIVersion()	{ return "1.4"; }
	function GetURL()		{ return "http://www.tt-forums.net/viewtopic.php?f=65&t=69827"; }
	function GetSettings() {

		AddSetting({ name = "industry_NewGRF",
				description = "Which Industry set is being used?",
				easy_value = 1,
				medium_value = 1,
				hard_value = 1,
				custom_value = 1,
				flags = CONFIG_NONE, min_value = 1, max_value = 10 });
		AddLabels("industry_NewGRF", { _1 = "Baseset: Temperate",
					_2 = "Baseset: Arctic",
					_3 = "Baseset: Tropical",
					_4 = "Baseset: Toyland",
					_5 = "FIRS: Firs economy",
					_6 = "FIRS: Temperate basic",
					_7 = "FIRS: Arctic basic",
					_8 = "FIRS: Tropic Basic",
					_9 = "FIRS: Hearth of Darkness",
					_10 = "ECS: All Vectors" });

		AddSetting({ name = "goal_scale_factor",
				description = "Difficulty level (easy = 60, normal = 100, hard = 140)",
				easy_value = 60,
				medium_value = 100,
				hard_value = 140,
				custom_value = 100,
				flags = CONFIG_INGAME, min_value = 1, max_value = 1000 });

		AddSetting({ name = "log_level", 
				description = "Debug: Log level (higher = print more)", 
				easy_value = 1,
				medium_value = 1,
				hard_value = 1,
				custom_value = 1,
				flags = CONFIG_INGAME, min_value = 1, max_value = 3 });
		AddLabels("log_level", { _1 = "1: Info", _2 = "2: Verbose", _3 = "3: Debug" });
	}
}

RegisterGS(MainClass());
