class eco.Economy {
	towns_manager = null;
	industries_manager = null;
	constructor() {}
	
	function Initialize () {
		industries_manager = eco.IndustriesManager(this);
		towns_manager = eco.TownsManager(this);
	}
	
	
	function GetImpactorsForTown(town) {
		
		local industries = industries_manager.GetIndustries();
		local impactors = [];
		
		foreach(industry in industries) {
			local tile = industry.GetTile();
			local town_id = tile.GetClosestTownId();
			if(town_id == town.GetTownId()) {
				impactors.append(industry);
			}
		} 
		
		return impactors;
	}
	
	function Update() {
		industries_manager.Update();
		towns_manager.Update();
	}
	
	
	
	function HandleEvent(event) {
		local event_type = event.GetEventType();
		if (event_type == GSEvent.ET_INDUSTRY_OPEN ) {
			local gs_event_industry_open = GSEventIndustryOpen.Convert(event);
			local industry_id = gs_event_industry_open.GetIndustryID();
			GSLog.Info("Industry opened");
			industries_manager.AddIndustry(industry_id);
			
		} else if (event_type == GSEvent.ET_INDUSTRY_CLOSE) {
			local gs_event_industry_close = GSEventIndustryClose.Convert(event);
			local industry_id = gs_event_industry_close.GetIndustryID();
			industries_manager.RemoveIndustry(industry_id);
		}
		towns_manager.FindTownsImpactors();
	}
	
	function CleanUp(){
		RemoveSigns();
	}
	
	function RemoveSigns(){
		local sign_list = GSSignList();
		foreach (sign_id, value in sign_list) {
			GSSign.RemoveSign(sign_id)
		}
	}
	
	
}


