class eco.IndustriesManager {
	
	economy = null;
	industries = [];
	signs_displayed = false;
	
	constructor(economy) {
		this.economy = economy;
		CreateIndustries();
	}
	
	function RecreateIndustries() {
		RemoveIndustries();
		CreateIndustries();
	}
	
	function RemoveIndustries() {
		for(local i = 0 ; i < industries.len(); i++) {
			local industry = industries[i];
			industry.Remove();
		}
	}
	
	function CreateIndustries() {
		local gs_industry_list = GSIndustryList();
		foreach(industry_id, value in gs_industry_list) {
			industries.append(eco.Industry(this, industry_id));
		}
	}
	
	function AddIndustry(industry_id) {
		industries.append(eco.Industry(this, industry_id));
	}
	
	function RemoveIndustry(industry_id)  {
		local index = GetIndustryIndex(industry_id);
		industries[index].Remove();
		industries.remove(index);
		GSLog.Info("industry index: " +index);
		
	}
	
	function GetIndustry(industry_id) {
		local index = GetIndustryIndex(industry_id);
		return industries[index];
	}
	
	function GetIndustryIndex(industry_id) {
		foreach(index, industry in industries) {
			if (industry_id == industry.GetIndustryId()) {
				
				return index;
			}
		}
	}
	
	function SetDisplayIndustriesSigns(display) {
		
		if(display == false && (signs_displayed == true)) {
			RemoveIndustriesSigns()
		} else if (display == true && (signs_displayed == false )){
			DisplayIndustriesSigns()
		}
	}
	
	function DisplayIndustriesSigns() {
		for(local i = 0 ; i < industries.len(); i++) {
			local industry = industries[i];
			industry.BuildSign();
		}
		GSLog.Info("Placing signs");
		signs_displayed = true;
	}
	
	function RemoveIndustriesSigns(){
		for(local i = 0 ; i < industries.len(); i++) {
			local industry = industries[i];
			industry.RemoveSign();
		}
		GSLog.Info("Removing signs");
		signs_displayed = false;
	}
	
	function GetIndustries() {
		return industries;
		
	}
	
	function Update() {
	}
	
}