class eco.Industry extends eco.GrowthImpactor {
	
	industries_manager = null;
	industry_id = null;
	tile = null;
	info_sign = null;
	last_month_delivery = null;
	
	constructor(industries_manager, industry_id) {
		this.industries_manager = industries_manager;
		this.industry_id = industry_id;
		info_sign = eco.Sign(GetTile(), GetTypeName());
		local place_signs = GSController.GetSetting("place_signs").tofloat();
		if(place_signs == 1) {
			info_sign.Build();
		} 
	}
	
	// Return Tile object representing location of this Industry 
	function GetTile() {
		local tile_index = GSIndustry.GetLocation(industry_id);
		local tile = eco.Tile(tile_index);
		return tile;
	}
	
	
	function GetImpactorName() {
		return GetName();
	}
	
	// Bigger impact means faster growth
	// The impact value is between 0 and 1
	
	// Overrided
	function GetAmount() {
		local cargo_id;
		local type_name = GetTypeName();
		local cargo_name = "";
		/*switch (type_name){ 
			case "Power Station":
				cargo_id = 1;
				cargo_name = "Coal";
				break;
			default:
				info_sign.SetText(" ");
				return 0;
				break;
				
				
		}*/
		local produced = GetProductionAmount(cargo_id);
		local delivered = GetIndustryDeliveryAmount(cargo_id);
		local amount =  delivered;
		info_sign.SetText(cargo_name + " delivered: " + delivered );
		return amount.tofloat();
	}
	
	function GetAmountPerThousand() {
		switch (GetTypeName()){ 
			case "Power Station":
				return GSController.GetSetting("coal_per_thousand").tofloat();;
				
				break;
			default:
				return 10;
				break;
				
				
		}
		
		
	}
	
	// Calculate factors of the impact 
	function GetProductionAmount(cargo_id) {
		local production = GSIndustry.GetLastMonthProduction(industry_id, cargo_id);
		return production;
	}
	
	
	
	// Can be called only once in scope of class
	function GetIndustryPickupAmount(cargo_id) {
		local amount = 0;
		for(local company_id = GSCompany.COMPANY_FIRST; company_id <= GSCompany.COMPANY_LAST; company_id++){
			amount +=  GSCargoMonitor.GetIndustryPickupAmount(company_id, cargo_id, industry_id, true);
		}
		//GSLog.Info(GSCargo.GetCargoLabel(cargo_id) + ": " +amount);
		return amount;
	}
	
	
	
	
	function GetIndustryDeliveryAmount	(cargo_id) {
		local amount = 0;
		for(local company_id = GSCompany.COMPANY_FIRST; company_id <= GSCompany.COMPANY_LAST; company_id++){
			amount +=  GSCargoMonitor.GetIndustryDeliveryAmount(company_id, cargo_id, industry_id, true);
		}
		if (amount >= 0) {
			last_month_delivery = amount;
			return last_month_delivery;
		} else {
			return 0;
		}
	}
	
	
	
	
	// Get the full name of the industry - including the name 
	// of the city to which it belongs
	function GetName () {
		local name = GSIndustry.GetName(industry_id);
		return name;
	}
	
	function GetTypeName() {
		local industry_type = GSIndustry.GetIndustryType(industry_id);
		local type_name = GSIndustryType.GetName(industry_type);
		return type_name;
	}
	
	
	function GetIndustryId() {
		return industry_id;
	}
	
	function Remove(){
		RemoveSign();
	}
	
	function BuildSign() {
		info_sign = eco.Sign(GetTile(), GetTypeName());
		info_sign.Build();
	}
	
	function RemoveSign() {
		info_sign.Remove();
	}
	
	function GetAcceptedCargos() {
		local industry_type = GSIndustry.GetIndustryType(industry_id);
		local cargos = [];
		local gs_cargo_list = GSIndustryType.GetAcceptedCargo(industry_type);
		foreach(cargo_id, _ in gs_cargo_list) {
			local cargo_label = GSCargo.GetCargoLabel(cargo_id);
			cargos.append(eco.Cargo(cargo_id, cargo_label ));
		}
		
		return cargos;
		
	}
	
	function ListAcceptedCargos() {
		local accepted_cargos = GetAcceptedCargos();
		foreach(cargo in accepted_cargos) {
			Log.Info("Cargo: " + cargo.GetLabel(), Log.LVL_INFO);
		}
	}
	
	
	
}