require("version.nut");

class FMainClass extends GSInfo {
	function GetAuthor()		{ return "lukasz1985, Mczapkie"; }
	function GetName()			{ return "RealGrowth_TileLabelIndustryBuilder"; }
	function GetDescription() 	{ return "Growth simulation for openttd temperate industry and industry builder"; }
	function GetVersion()		{ return SELF_VERSION; }
	function GetDate()			{ return "2014-07-21"; }
	function CreateInstance()	{ return "Main"; }
	function GetShortName()		{ return "RGIB"; }
	function GetAPIVersion()	{ return "1.3"; }
	function GetUrl()			{ return ""; }

	function GetSettings() {
		
		AddSetting({
			name = "pass_impact", 
			description = "Impact of passangers(%, def.:300)", 
			easy_value = 600, 
			medium_value = 300, 
			hard_value = 200, 
			custom_value = 400, 
			flags = CONFIG_INGAME, 
			min_value = 0, 
			max_value = 1000
		});
		
		AddSetting({
			name = "mail_impact", 
			description = "Impact of mail(%, def.:500)", 
			easy_value = 800, 
			medium_value = 500, 
			hard_value = 300, 
			custom_value = 500, 
			flags = CONFIG_INGAME, 
			min_value = 0, 
			max_value = 1500
		});
		
		AddSetting({
			name = "good_impact", 
			description = "Impact of goods(%, def.:500)", 
			easy_value = 750, 
			medium_value = 300, 
			hard_value = 100, 
			custom_value = 500, 
			flags = CONFIG_INGAME, 
			min_value = 0, 
			max_value = 1000
		});
		
		
		
		AddSetting({
			name = "place_signs", 
			description = "Place signs with industries names.", 
			easy_value = 0, 
			medium_value = 0, 
			hard_value = 0, 
			custom_value = 0, 
			flags = CONFIG_INGAME | CONFIG_BOOLEAN
		});
		AddSetting({
			name = "log_level", description = "Debug: Log level (higher = print more)", easy_value = 3, medium_value = 3, hard_value = 3, custom_value = 3, flags = CONFIG_INGAME, min_value = 1, max_value = 3
		});
		AddLabels("log_level", {_1 = "1: Info", _2 = "2: Verbose", _3 = "3: Debug" } );
	}
}

RegisterGS(FMainClass());
