/*
Author - lukasz1985

Copyrighted under MIT license.

Copyright (C) 2013 Lukasz Michalczyk


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice
 shall be included in all copies or substantial portions 
 of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY
 OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
  LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 ARISING FROM, OUT OF OR IN CONNECTION WITH THE
  SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

/*
Script based upon MinimalGS library: 
http://www.tt-forums.net/viewtopic.php?f=65&t=62163
*/

// Namespace declaration
eco <- {};

// Temporary solution
const COMPANY_SELF = 0;


/** Import SuperLib for GameScript **/
import("util.superlib", "SuperLib", 38);
Result <- SuperLib.Result;
Log <- SuperLib.Log;
Helper <- SuperLib.Helper;
Tile <- SuperLib.Tile;
Direction <- SuperLib.Direction;
Town <- SuperLib.Town;
Industry <- SuperLib.Industry;
Story <- SuperLib.Story;


require("cargo.nut");
require("economy.nut");
require("towns_manager.nut");
require("industries_manager.nut");
require("impacted.nut");

require("impactor.nut");
require("growth_impactor.nut");

require("tile.nut");
require("sign.nut")
require("town.nut");
require("industry.nut");
require("tile.nut");

require("manager.nut");
require("vehicle.nut");

//tile industry builder
require("industry_builder.nut")


class Main extends GSController 
{
	days_passed = 0;
	economy = null;
	manager = null;
	current_date = null;
	_load_data = null;
	_init_done = null;

     industryBuilder = null;

	constructor(){
		this._init_done = false;
		this._load_data = null;
//		this._loaded_from_version = null;
		
		this.industryBuilder = IndustryBuilder();
		this.industryBuilder.setPrefix(">>>");
		this.industryBuilder.setSeparator(":"); 
		switch (GSController.GetSetting("log_level"))
		{
		case 1: 
			this.industryBuilder.setRemoveSigns(true);  
			this.industryBuilder.setPlaceSignAfterBuild(1); //quiet
			break;
		case 2: 
			this.industryBuilder.setRemoveSigns(true);  
			this.industryBuilder.setPlaceSignAfterBuild(2); //verbose
			break;
		case 3: 
			this.industryBuilder.setRemoveSigns(false); 
			this.industryBuilder.setPlaceSignAfterBuild(3); //debug all
			this.industryBuilder.dumpIndustryNumbers();
			break;
		}
		this.industryBuilder.setTryCount( 12 );		
		this.industryBuilder.setYearCount( 50 );		//todo: as parameter
}
	
	function Start(){
//	if (Helper.HasWorldGenBug()) GSController.Sleep(1);
		
Init();
		current_date = GSDate.GetCurrentDate();
		
		// Wait for the game to start
		this.Sleep(1);
	
		// Welcome human player
	
		InitSettings();
		
		economy = eco.Economy();
		economy.CleanUp();
		economy.Initialize();
		manager = eco.Manager();
		
		
		
		/**
		The loop 
		*/
   	      local last_loop_date = GSDate.GetCurrentDate();
		while (true) {
			local loop_start_tick = GSController.GetTick();
			local current_date = GSDate.GetCurrentDate();
			local days_since_last_update = current_date - this.current_date;
			this.current_date = current_date; 
			if (days_since_last_update >= 1) {
				days_passed += days_since_last_update;
				Update();
			}
		if (last_loop_date != null) {
			local year = GSDate.GetYear(current_date);
			local month = GSDate.GetMonth(current_date);
			if (year != GSDate.GetYear(last_loop_date)) {
				this.EndOfYear(year);
			}
			if (month != GSDate.GetMonth(last_loop_date)) {
				this.EndOfMonth(year);
			}
		}
		last_loop_date = current_date;

	
			// Loop with a frequency of five days
			local ticks_used = GSController.GetTick() - loop_start_tick;
			
			Sleep(max(1, 1 * 74 - ticks_used));
		}
		
		while(GSEventController.IsEventWaiting()) {
			HandleEvents();
		}
	}
	
	/**
	Events handling for industries and vehicle crashes
	*/
	function HandleEvents() {
		if(GSEventController.IsEventWaiting())	{
			local event = GSEventController.GetNextEvent();
			economy.HandleEvent(event);
			manager.HandleEvent(event);
		}
	}
	
	function Update() {
		local current_date = GSDate.GetCurrentDate();
		local day_of_month = GSDate.GetDayOfMonth(current_date)
		if (day_of_month  == 1 ){
			// Every first of month
			
			MonthlyUpdate();
		}
		
		// Every day
		manager.DailyUpdate();
		
		if(GSEventController.IsEventWaiting())	{
			local event = GSEventController.GetNextEvent();
			economy.HandleEvent(event);
			manager.HandleEvent(event);
		}
	}
	
	function MonthlyUpdate() {
		manager.MonthlyUpdate();
		economy.Update();
	}
	
	
	function Init()
	{
	industryBuilder.init();

	if (this._load_data != null) {
		// Copy loaded data from this._loaded_data to this.*
		// or do whatever you like with the loaded data		
		industryBuilder.importFromSave( this._loaded_data.industry_tile_labels );

	} else {
		// construct goals etc.
	}

	industryBuilder.readFromMap();
	this.industryBuilder.dump();
	
	// Indicate that all data structures has been initialized/restored.
	this._init_done = true;
	this._load_data = null; // the loaded data has no more use now after that _init_done is true.

	}
	

function EndOfMonth(year)
{
	this.industryBuilder.onNewMonth(year);
}

//
// Called by our main loop when a new year has been reached.

function EndOfYear(year)
{
	this.industryBuilder.onNewYear(year);
}


	function Save()
	{
		Log.Info("Saving data to savegame", Log.LVL_INFO);
		return { 
			some_data = null,
			some_other_data = null
       		industry_tile_labels = industryBuilder.exportToSave()
		};
	}
	
	function Load(version, tbl)
	{
		Log.Info("Loading data from savegame made with version " + version + " of the game script", Log.LVL_INFO);	
		// Store a copy of the table from the save game
		// but do not process the loaded data yet. Wait with that to Init
		// so that OpenTTD doesn't kick us for taking too long to load.
		this._load_data = {}
	   	foreach(key, val in tbl)
		{
			this._load_data.rawset(key, val);
		}	
	}
	
	function InitSettings()
	{
		GSGameSettings.SetValue("economy.town_growth_rate", 4);
	}
}

