class eco.Manager {
	function HandleEvent(event) {
		
		local event_type = event.GetEventType();
		if(event_type == GSEvent.ET_VEHICLE_CRASHED) {
			local vehicle_crashed_event = GSEventVehicleCrashed.Convert(event);
			local vehicle_id = vehicle_crashed_event.GetVehicleID();
			local vehicle = eco.Vehicle(vehicle_id);
			local reason = vehicle_crashed_event.GetCrashReason();
			
			GSLog.Info("crash");
			if (reason == GSEventVehicleCrashed.CRASH_RV_LEVEL_CROSSING) {
				ReplaceRoadVehicle(vehicle);
			}
		}
	}
	
	
	function ReplaceRoadVehicle(road_vehicle) {
		local tile = road_vehicle.GetLocation();
		local owner = road_vehicle.GetOwner();
		local depot_tile_index = FindNearestRVDepot(tile, owner);
		local vehicle = road_vehicle.Clone(depot_tile_index);
		
		vehicle.StartStop();
	}
	
	function DailyUpdate() {
	}
	
	
	function MonthlyUpdate() {
		CheckForOrders();
	}
	
	function CheckForOrders() {
		ReadSigns();
		
	}
	
	function ReadSigns() {
		local company = GSCompanyMode(COMPANY_SELF);
		local sign_list = GSSignList();
		foreach(sign_id , value in sign_list) {
			local sign = eco.Sign.FromSignId(sign_id)
			EvaluateSignOrder(sign);
		}
	}
	
	
	function EvaluateSignOrder(sign) {
		//GSLog.Info(sign.GetText());
		local sign_text = sign.GetText();
		
		local tile = sign.GetLocation();
		local town_id = tile.GetClosestTownId();
		local company = GSCompanyMode(COMPANY_SELF);
		if(sign_text == "Advertising - small") {
			GSLog.Info("Small advertising");
			// Found small advertising campaign in the city
			GSTown.PerformTownAction(town_id, GSTown.TOWN_ACTION_ADVERTISE_SMALL);
		} else if (sign_text == "Advertising - medium"){
			GSTown.PerformTownAction(town_id, GSTown.TOWN_ACTION_ADVERTISE_MEDIUM);
		} else if (sign_text == "Advertising - large"){
			GSTown.PerformTownAction(town_id, GSTown.TOWN_ACTION_ADVERTISE_LARGE);
		} else if (sign_text == "Fund buildings") {
			GSLog.Info("Funding buildings");
			GSTown.PerformTownAction(town_id, GSTown.TOWN_ACTION_FUND_BUILDINGS);
		}
	}
	
	function FoundSmallAdvertising() {
		
	}
	function FindNearestRVDepot(tile, owner) {
		
		
		
		local depots_list = GSDepotList(GSTile.TRANSPORT_ROAD);
		
		//GSLog.Info("self: " + GSCompany.COMPANY_SELF);
		//for(local start = GSCompany.COMPANY_FIRST ; start < GSCompany.COMPANY_LAST; start++ ) {
		//	GSLog.Info( "company index:  " + start);
		//}
		//GSLog.Info("Resolved self:" +  GSCompany.ResolveCompanyID(0));
		local last_distance = 2048;
		local last_index = 0; 
		
		local depots_table = { [last_index] = last_distance};
		
		
		foreach(tile_index, value in depots_list) {
			local current_tile = eco.Tile(tile_index);
			
			GSLog.Info(tile.GetDistanceToTile(current_tile));
			if (current_tile.GetOwner() == owner) {
				local distance = tile.GetDistanceToTile(current_tile);
				if(distance < last_distance) {
					last_distance = distance;
					//delete depots_table[last_index];
					//depots_table[tile_index] <- distance;
					last_index = tile_index;
				}
				//GSLog.Info(distance);
			}
		}
		return last_index;
		
	}
}


