class eco.Tile {
	tile_index = null;
	
	constructor(tile_index){
		this.tile_index = tile_index;
	}
	
	function IsWithinTownInfluence(town) {
		local town_id = town.GetTownId();
		local is_within_town_influence = GSTile.IsWithinTownInfluence(tile_index, town_id);
		
	}
	
	function GetClosestTownId() {
		local town_id = GSTile.GetClosestTown(tile_index);
		return town_id;
	}
	
	function GetTileIndex () {
		return tile_index;
	}
	
	function Demolish() {
		
		local company = GSCompanyMode(GSCompany.COMPANY_SELF);
		//GSSign.BuildSign(tile_index, "demolish");
		//	GSLog.Info(tile_index);
		GSTile.DemolishTile(tile_index);
		
	}
	
	
		
	static function GetRectangularArea(center_x, center_y, radius) {
		local tiles = [];
		
		local min_x, min_y, max_x, max_y;
		
		min_x = center_x - radius;
		min_y = center_y - radius;
		max_x = center_x + radius;
		max_y = center_y + radius;
		
		for(local current_x = min_x; current_x < max_x ; current_x++) {
			for(local current_y = min_y; current_y < max_y; current_y++) {
				local is_within_width = current_x > 0 && current_x < GSMap.GetMapSizeX();
				local is_within_height = current_y > 0 && current_y < GSMap.GetMapSizeY();
				if(is_within_height && is_within_width) {
					local tile_index = GSMap.GetTileIndex(current_x, current_y);
					local tile = eco.Tile(tile_index);
					tiles.append(tile);
				}
			}
		}
		
		return tiles;
	}
	
	function GetDistanceToTile(tile) {
		return GSMap.DistanceManhattan(tile_index, tile.GetTileIndex());
	}
	
	function GetOwner() {
		return GSTile.GetOwner(tile_index);
	}
	
	
	function BelongsToPlayer(){
		return (GetOwner() == GSCompany.COMPANY_SELF);
	}
	
}