
class eco.Town extends eco.Impacted{
	pop_effect_this_month = null;
	pop_effect_prev_month = null;
	pop_effect_before_prev_month = null;
	towns_manager = null;
	town_id = null;
	
	pass_impact = GSController.GetSetting("pass_impact").tofloat();
	mail_impact = GSController.GetSetting("mail_impact").tofloat();
	good_impact = GSController.GetSetting("good_impact").tofloat();
	
	constructor(towns_manager, town_id) {
		this.town_id = town_id;
		this.towns_manager = towns_manager;
		local current_population = GetCurrentPopulation();
		this.pop_effect_this_month = current_population;
		this.pop_effect_before_prev_month = this.pop_effect_this_month;
		this.pop_effect_prev_month = this.pop_effect_this_month;
		
	}
	
	function SetGrowthRate(days_between_town_growth) {
		GSTown.SetGrowthRate(town_id, days_between_town_growth);
	}
	
	
	function Update() {
		local target_population =  CalculateTargetPopulation();
		PerformActions(target_population);
	}
	
	function GetCurrentPopulation() {
		return GSTown.GetPopulation(town_id);
	}
	
	/**
	This method can be called only once per month
	It has side effects: it shows text in town window
	*/ 
	function CalculateTargetPopulation() {
		local town_name = GetName();
			
		local current_population = GetCurrentPopulation();
		
		local passanger_transported = 0;
		local mail_transported = 0;
		local goods_transported = 0;
		local sum_transported = 0;
		
		local passanger_effect = 0;
		local mail_effect = 0;
		local goods_effect = 0;
			
		local text_pass;
		local text_mail;
		local text_goods;
		
		local town_text;
	
		// Move the population history backward
		pop_effect_before_prev_month = pop_effect_prev_month;
		pop_effect_prev_month = pop_effect_this_month;
			
			
		// Town effect goods
		// Passangers
		passanger_transported =  GetPassangersTransported();
		passanger_effect = passanger_transported * (pass_impact / 100.0);
		
		// Mail
		mail_transported = GetMailTransported();
		mail_effect =  mail_transported * (mail_impact / 100.0);
	
		// Goods			
		goods_transported = GetGoodsTransported();
		goods_effect =  goods_transported * (good_impact / 100.0);

		pop_effect_this_month += passanger_effect + mail_effect + goods_effect;
	
		
		pop_effect_this_month = 
			passanger_effect  
			+ mail_effect 
			+ goods_effect; 	
		pop_effect_this_month = pop_effect_this_month.tointeger();
		
		// Calculate target poulation basing on the average from the 3 last months
		local target_population = (pop_effect_this_month + pop_effect_prev_month + pop_effect_before_prev_month) / 3.0 + 10;  //Mc: added 10 to avoid shrinking to 0
		target_population = target_population.tointeger();
		
		
		// Getting text into city window
		local text_city;
			
		local text_target_population;
		if(target_population.tointeger() > current_population) {
			text_target_population = GSText(GSText.STR_TARGET_POPULATION_HIGHER, target_population);	
		} else {
			text_target_population = GSText(GSText.STR_TARGET_POPULATION_LOWER, target_population);
		}
		
		local text_impact_history = GSText(GSText.STR_IMPACT_HISTORY, 
			pop_effect_this_month, 
			pop_effect_prev_month, 
			pop_effect_before_prev_month);
		
		
		local text_pass_mail_goods = GSText(GSText.STR_PASS_MAIL_GOODS
			passanger_transported, passanger_effect.tointeger(),
			mail_transported, mail_effect.tointeger(), 
			goods_transported, goods_effect.tointeger()
		);
		
		text_city = GSText(GSText.STR_CONCAT_1_6_6,
		 	text_target_population, 
		 	text_impact_history,
		 	text_pass_mail_goods
	 	);
		SetText(text_city);
		
		if(town_name == "Debug") {
			GSLog.Info("############# Goods effect ##################")
			GSLog.Info("Pass: " + passanger_transported + ":" + passanger_effect);
			GSLog.Info("Mail: " + mail_transported + ":" + mail_effect);
			GSLog.Info("Good: " + goods_transported + ":" + goods_effect);
			
			GSLog.Info("############# Pop effect ##################")
			GSLog.Info("Effect this month:" + pop_effect_this_month);
			GSLog.Info("Effect last month:" + pop_effect_prev_month);
			GSLog.Info("Effect before prev month:" + pop_effect_before_prev_month);
		}
		
		// LOG
		// GSLog.Info("impactor_effect: " + impactor_effect);
		
		/*
		GSLog.Info("passengers:"+ GetPassangersTransported() + "| passanger_effect: " + passanger_effect);
		GSLog.Info( "mail_effect: " + mail_effect);
		GSLog.Info( "goods_effect: " + mail_effect);
		GSLog.Info( "division: " + GetPassangersTransported() / pass_impact )
		GSLog.Info(impactors.len());
		*/
		return target_population; 	
	}
	
	
	// Private
	function GetPassangersTransported() {
		return GetTownDeliveryAmount(0);
	}
	
	// Private
	function GetMailTransported() {
		return GetTownDeliveryAmount(2);
	}
	
	// Private
	function GetGoodsTransported() {
		return GetTownDeliveryAmount(5);
	}
	
	// Private
	function GetTownDeliveryAmount(cargo_id) {
		local amount = 0;
		for(local company_id = GSCompany.COMPANY_FIRST; company_id <= GSCompany.COMPANY_LAST; company_id++){
			amount +=  GSCargoMonitor.GetTownDeliveryAmount(company_id, cargo_id, town_id, true);
		}
		// LOG
		return amount;
	}
	
	function GetTile () {
		local tile_index = GSTown.GetLocation(town_id);
		return eco.Tile(tile_index);
	}
	
	function GetTownId() {
		return town_id;
	}
	
	// Private
	function SetText(text) {
		GSTown.SetText(town_id, text);
	}
	
	
	function PerformActions(target_population) {
		local current_population = GetCurrentPopulation()
		if(target_population > current_population){
				local houses_per_pop = 10.0 / 1000.0;
				local difference = target_population - current_population;
				local houses_to_expand = houses_per_pop * difference;
				ExpandTown(houses_to_expand.tointeger() + 1); // At least one house is guaranteed for expansion
				SetGrowthRate(1);
		} else {
				SetGrowthRate( 30 * 1000);
		}
			
	}
	
	function ExpandTown (houses) {
		local houses_built = 0;
		while(houses_built < houses) {
			local expanded = GSTown.ExpandTown(town_id, 1);
			if (expanded) {
				houses_built+= 1;
			} 
		}
	}
	
	function ShrinkTown() {
		local tiles = eco.Tile.GetRectangularArea(30,30,5);
		foreach(tile in tiles) {
			tile.Demolish();
		}
		
	}
	
	function GetName() {
		return GSTown.GetName(town_id);
	}
}