
class eco.TownsManager  {
	towns = [];
	economy = null;
	
	constructor(economy) {
		this.economy = economy;
		CreateImpactedTowns();
		FindTownsImpactors();
	}
	
	
	function CreateImpactedTowns() {
		local current_index = 0;
		local gs_town_list = GSTownList();
		foreach (town_id, value in gs_town_list ) {
				
			towns.append(eco.Town(this, town_id));
		}	
		
	}
	
	function FindTownsImpactors () {
		foreach(town in towns) {
			local impactors = economy.GetImpactorsForTown(town);
			town.SetImpactors(impactors);
		}
	}
	
	function UpdateTowns() {
		foreach(town in towns) {
			town.Update();
		}
	}
	
	function Update() {
		FindTownsImpactors();
		UpdateTowns();
	}
	
	
}
